package parser;

import token.*;
import token.tokenizer.*;
import extvisitor.*;

/**
 * Factory for Empty grammar terminals.
 * Note that this factory must always be the last 
 * choice in any combination symbol.
 */
public class MTSymbolFact extends ATokVisitorFact {
  /**
   * Constructor for Empty grammar terminals.
   *
   * @param tkz tokenizer to use
   */
  public MTSymbolFact(ITokenizer tkz) {
    super("MTSymbol", tkz);
  }
  
  
  
  /**
   * Make a visitor to parse an empty terminal.
   *
   * @return visitor to parse an empty terminal
   */
  
  private ITokVisitorCmd<IGrammarSymbol, Object> makeCmd() {
    return new ITokVisitorCmd<IGrammarSymbol, Object>() {
      public IGrammarSymbol apply(String idx, Token host, Object... inps) {
        putBackToken(host);
        System.out.println("MTSymbolFact: Pushback("+host+")");
        return MTSymbol.Singleton;      }
    };
  }
  
  /**
   * Make a token visitor to parse an Empty terminal.
   *
   * @return token visitor
   */
  public ATokVisitor<IGrammarSymbol, Object> makeVisitor() {
    return new ATokVisitor<IGrammarSymbol, Object>(){
      {
        setDefaultCmd(makeCmd());
      }
    };
  }
  
  /**
   * Make a token visitor that will process the combination of this 
   * or the other given symbol 
   *
   * @param other The visitor for the other symbol in the combination 
   * @return A token visitor
   */
  public ATokVisitor<IGrammarSymbol, Object> makeCombinedVisitor(ATokVisitor<IGrammarSymbol, Object> other) {
    return new ATokVisitor<IGrammarSymbol, Object>(other) {
      {
        setDefaultCmd(makeCmd());
      }
    };
  }

  public String toString() {
    return "MTSymbolFact";
  }
  
}

